/*
** CompuSys.h
** Common Interface for different computer specific part of
** the disassembler.
*/

/*
** macros used by specific library and by DIS6502
*/
#define MAX_SEGMENTS     256

/*
** structures shared between specific library and DIS6502
*/
typedef struct SEGMENT
          {
          WORD      wBegin;
          WORD      wEnd;
          BYTE      *lpDump;
          BYTE      *lpType;
          DWORD     dwLineNumber;
          BOOL      bBinary;
          BYTE      szTitle[22];
          } SEGMENT;

/*
** Menu to enable or disable
*/
#define MENU_BINARY_FILE      0x01
#define MENU_DISK_FILE        0x02
#define MENU_DISK_BOOT        0x04
#define MENU_DISK_SECTORS     0x08
#define MENU_SPY              0x10
#define MENU_TRANSFER         0x20
#define MENU_ALL              0xFF

/*
** type definition for each entry point
*/
typedef BOOL (CALLBACK *COMPUINIT)(HINSTANCE hInst);
typedef void (CALLBACK *COMPUTERM)(void);
typedef WORD (CALLBACK *COMPUGETMENU)(void);
typedef BOOL (CALLBACK *COMPULOADSEGMENT)(int fd, SEGMENT *lpSeg, BOOL bReadType);
typedef BOOL (CALLBACK *COMPUUPDATESEGMENT)(HWND hSegmentList, SEGMENT *lpSeg);
typedef BOOL (CALLBACK *COMPUREADFILE)(HWND hSegmentList, int fd, SEGMENT Segment[], int nFirstSeg);
typedef BYTE (CALLBACK *COMPUGETRETURN)(void);
